; Exercise 2.97:

; Implement this algorithm as a procedure reduce-terms that takes two term lists n and d as arguments and returns a list nn, dd, which are n and d reduced to lowest terms via the algorithm given above. Also write a procedure reduce-poly, analogous to add-poly, that checks to see if the two polys have the same variable. If so, reduce-poly strips off the variable and passes the problem to reduce-terms, then reattaches the variable to the two term lists supplied by reduce-terms.
; Define a procedure analogous to reduce-terms that does what the original make-rat did for integers:
; (define (reduce-integers n d)
;   (let ((g (gcd n d)))
;     (list (/ n g) (/ d g))))
; and define reduce as a generic operation that calls apply-generic to dispatch to either reduce-poly (for polynomial arguments) or reduce-integers (for scheme-number arguments). You can now easily make the rational-arithmetic package reduce fractions to lowest terms by having make-rat call reduce before combining the given numerator and denominator to form a rational number. The system now handles rational expressions in either integers or polynomials. To test your program, try the example at the beginning of this extended exercise:

; (define p1 
;   (make-polynomial 'x '((1 1) (0 1))))
; (define p2 
;   (make-polynomial 'x '((3 1) (0 -1))))
; (define p3 
;   (make-polynomial 'x '((1 1))))
; (define p4 
;   (make-polynomial 'x '((2 1) (0 -1))))
; (define rf1 (make-rational p1 p2))
; (define rf2 (make-rational p3 p4))
; (add rf1 rf2)
; See if you get the correct answer, correctly reduced to lowest terms.

; The GCD computation is at the heart of any system that does operations on rational functions. The algorithm used above, although mathematically straightforward, is extremely slow. The slowness is due partly to the large number of division operations and partly to the enormous size of the intermediate coefficients generated by the pseudodivisions. One of the active areas in the development of algebraic-manipulation systems is the design of better algorithms for computing polynomial GCDs.128
; (load "/home/soulomoon/Documents/git/SICP/Chapter2/source.scm")
(load "C:/git/SICP/Chapter2/source.scm")
(define (apply-generic op . args)
  (let ((type-tags (map type-tag args)))
    (let ((proc (get op type-tags)))
      (if proc
          (let ((result (apply proc (map contents args))))
              result
          )
          (cond 
              ((> (length args) 2) 
               (apply apply-generic 
                      (cons op 
                            (list (car args) 
                                  (apply apply-generic 
                                         (cons op 
                                               (cdr args)))) )))
              ((= (length args) 2)
                (let ((type1 (car type-tags))
                      (type2 (cadr type-tags))
                      (a1 (car args))
                      (a2 (cadr args)))
    
                  (let ((level1 (get-level type1 'level))
                        (level2 (get-level type2 'level)))
                        (cond 
                              ((< level1 level2) 
                                (apply-generic 
                                  op (raise a1) a2))
                              ((> level1 level2) 
                                (apply-generic 
                                  op a1 (raise a2)))
                              (else
                              (error 
                                "No method for 
                                these types"
                                (list 
                                op 
                                type-tags)))))))
              (else (error 
               "No method for these types"
               (list op type-tags))))))))


(define (install_transform_package)
  ; raise
  (define integer->rational
    (lambda (x) (make-rational (value x) 1))
  )
  (define rational->scheme-number
    (lambda (x) (make-scheme-number (/ (numer x) (denom x))))
  )
  (define scheme-number->complex
    (lambda (x) (make-complex-from-real-imag x 0))
  )
  (define complex->polynomial
    (lambda (x) (make-polynomial 'x (list (make_term 0 (real-part x)))))
  )
  
  ; project 
  (define complex->scheme-number
    (lambda (x) (make-scheme-number (real-part x)))
  )
  (define scheme-number->rational
    (lambda (x) (make-rational (round x) 1))
  )
  (define rational->integer
    (lambda (x) (make-integer (rational->scheme-number x)))
  )

  ; raise
  (put-coercion 'integer 'raise
                integer->rational)
  (put-coercion 'scheme-number 'raise
                scheme-number->complex)
  (put-coercion 'rational 'raise
                rational->scheme-number)
  (put-coercion 'complex 'raise
                complex->polynomial)

  ; project
  (put-coercion 'complex 'project complex->scheme-number)
  (put-coercion 'scheme-number 'project scheme-number->rational)
  (put-coercion 'rational 'project rational->integer)


  (put-level 'integer 'level 1)
  (put-level 'rational 'level 2)
  (put-level 'scheme-number 'level 3)
  (put-level 'complex 'level 4)
  (put-level 'polynomial 'level 5)
                
'install_transform_done)
(install_transform_package)



(define (project x)
  (let ((lower (get-coercion (type-tag x) 'project)))
    (if lower
        (lower x)
        false)))

(define (drop x)
  (let ((low (project x)))
    (if (and low (equ? (raise low) x))
        (drop (project x))
        x
    )
  )
)
(define (raise x)
  (let ((raise (get-coercion (type-tag x) 'raise)))
    (if raise
        (raise x)
        (error 
               "No raise for this types"
               (type-tag x)))))

(define (install-rational-package)
  ;; internal procedures
  (define (numer x) (car x))
  (define (denom x) (cdr x))
  
  (define (reduce-integers n d)
  (let ((g (gcd n d)))
    (list (/ n g) (/ d g))))

  (define (make-rat n d)
    (let ((reduced_list (reduce n d)))
      (apply cons reduced_list)))
  (define (add-rat x y)
    (make-rat (add (mul (numer x) (denom y))
                 (mul (numer y) (denom x)))
              (mul (denom x) (denom y))))
  (define (sub-rat x y)
    (make-rat (- (mul (numer x) (denom y))
                 (mul (numer y) (denom x)))
              (mul (denom x) (denom y))))
  (define (mul-rat x y)
    (make-rat (mul (numer x) (numer y))
              (mul (denom x) (denom y))))
  (define (div-rat x y)
    (make-rat (mul (numer x) (denom y))
              (mul (denom x) (numer y))))

  (define (equ? x y)
    (if (and (= (numer x) (numer y)) (= (denom x) (denom y)))
        true
        false
    )
  )
  (define (rational_zero? x)
    (= 0 (numer x))
  )
  ;; interface to rest of the system
  (define (tag x) (attach-tag 'rational x))
  (put 'negation '(rational)
    (lambda (x) (tag (make-rat (negation (numer x)) (denom x))))
  )
  (put '=zero? '(rational) rational_zero?)

  (put 'equ? '(rational rational)
    equ?
  )
  (put 'reduce '(scheme-number scheme-number)
       reduce-integers)

  (put 'add '(rational rational)
       (lambda (x y) (tag (add-rat x y))))
  (put 'sub '(rational rational)
       (lambda (x y) (tag (sub-rat x y))))
  (put 'mul '(rational rational)
       (lambda (x y) (tag (mul-rat x y))))
  (put 'div '(rational rational)
       (lambda (x y) (tag (div-rat x y))))
  (put 'make 'rational
       (lambda (n d) (tag (make-rat n d))))
  (put 'numer '(rational) numer)
  (put 'denom '(rational) denom)
  'rational-package-done)
(install-rational-package)

      
(define (make-rational n d)
  ((get 'make 'rational) n d))

(define (value n)
  (apply-generic 'value n)
)
 
(define (numer z) 
  (apply-generic 'numer z))
(define (denom z) 
  (apply-generic 'denom z))

(define (install-polynomial-package)

  (define (the-empty-termlist) '())
  (define (first-term term-list) (car term-list))
  (define (rest-terms term-list) (cdr term-list))
  (define (empty-termlist? term-list) 
    (null? term-list))
  (define (make-term order coeff) 
    (list order coeff))
  (define (order term) (car term))
  (define (coeff term) (cadr term))

  (define (negation-termlist termlist)
    (define (negation-term term)
      (make-term (order term) (negation (coeff term))))
    (if (empty-termlist? termlist)
      termlist
      (adjoin-term (negation-term (first-term termlist)) (negation-termlist (rest-terms termlist)))))

  (define (sub-terms L1 L2)
    (add-terms L1 (negation-termlist L2)))
  (define (add-terms L1 L2)
    (cond ((empty-termlist? L1) L2)
          ((empty-termlist? L2) L1)
          (else
          (let ((t1 (first-term L1)) 
                (t2 (first-term L2)))
            (cond ((> (order t1) (order t2))
                    (adjoin-term
                    t1 
                    (add-terms (rest-terms L1) 
                                L2)))
                  ((< (order t1) (order t2))
                    (adjoin-term
                    t2 
                    (add-terms 
                      L1 
                      (rest-terms L2))))
                  (else
                    (adjoin-term
                    (make-term 
                      (order t1)
                      (add (coeff t1) 
                          (coeff t2)))
                    (add-terms 
                      (rest-terms L1)
                      (rest-terms L2)))))))))
  (define (mul-terms L1 L2)
    (if (empty-termlist? L1)
        (the-empty-termlist)
        (add-terms 
          (mul-term-by-all-terms 
            (first-term L1) L2)
          (mul-terms (rest-terms L1) L2))))

  (define (mul-term-by-all-terms t1 L)
    (if (empty-termlist? L)
        (the-empty-termlist)
        (let ((t2 (first-term L)))
          (adjoin-term
            (make-term 
              (+ (order t1) (order t2))
              (mul (coeff t1) (coeff t2)))
            (mul-term-by-all-terms 
              t1 
              (rest-terms L))))))

  (define (div-terms L1 L2)
    (if (empty-termlist? L1)
        (list (the-empty-termlist) 
              (the-empty-termlist))
        (let ((t1 (first-term L1))
              (t2 (first-term L2)))
              ; (display L1)(newline )
          (if (> (order t2) (order t1))
              (list (the-empty-termlist) L1)
              (let ((new-c (div (coeff t1) 
                                (coeff t2)))
                    (new-o (- (order t1) 
                              (order t2))))
                (let ((rest-of-result
                      (div-terms (sub-terms L1 (mul-term-by-all-terms (make-term new-o new-c) L2)) L2)))
                  (list (adjoin-term (make-term new-o new-c)
                              (car rest-of-result))
                        (cadr rest-of-result))))))))
  ;; internal procedures
  ;; representation of poly
  (define (make-poly variable term-list)
    (cons variable (list term-list)))
  (define (variable p) (car p))
  (define (term-list p) (cadr p))
  (define (same-variable? v1 v2)
    (define (variable? x) (symbol? x))
    (and (variable? v1)
        (variable? v2)
        (eq? v1 v2)))

  ;; representation of terms and term lists
  (define (adjoin-term term term-list)
    (if (=zero? (coeff term))
        term-list
        (cons term term-list)))
  (define (negation-poly p)
    (make-poly (variable p) (negation-termlist (term-list p)))
  )      
  (define (add-poly p1 p2)
    (if (same-variable? (variable p1) 
                        (variable p2))
        (make-poly 
          (variable p1)
          (add-terms (term-list p1)
                      (term-list p2)))
        (contents (add_expand p1 p2))))
  (define (max_order term_list) (apply max (map order term_list)))
  
  
  (define (add_expand p1 p2)
    (let (
      (var1 (variable p1))
      (var2 (variable p2))
      (max1 (max_order (term-list p1)))
      (max2 (max_order (term-list p2)))
      (merge (lambda (lp1 lp2)
        (let ((addent (tag lp1))
              (adder (make-polynomial (variable lp1)
                                          (list (make-term 0 (tag lp2))))))
        (make-poly
          (variable lp1)
          (contents (add adder addent)))))))
    (if (> max1 max2)
          (merge p1 p2)
          (merge p2 p1))))

  (define (mul_expand p1 p2)
    (let ((merge (lambda (lp1 lp2) 
                         (let ((t1 (make-term 0 (tag lp1))))
                              (cons (variable lp2) (mul-term-by-all-terms t1 (term-list lp2))))))
          (max1 (max_order (term-list p1)))
          (max2 (max_order (term-list p2))))
         (if (< max1 max2)
             (merge p1 p2)
             (merge p2 p1))))

  (define (mul-poly p1 p2)
    (if (same-variable? (variable p1) 
                        (variable p2))
        (make-poly
          (variable p1)
          (mul-terms (term-list p1)
                      (term-list p2)))
        (mul_expand p1 p2)))
    
  (define (div-poly p1 p2)
    (if (same-variable? (variable p1) 
                        (variable p2))
        (append
          (make-poly 
            (variable p1)
            (car (div-terms (term-list p1)
                        (term-list p2))))
          (cdr (div-terms (term-list p1)
                      (term-list p2))))
            (error "Polys not in same var: 
                    div-POLY"
                  (list p1 p2))
          ))

    (define (get_remain_list pol)
      (let ((remain (cddr pol)))
           (if (null? remain)
               (list (make-term 0 0))
               (car remain))))

  (define (remainder-terms a b)
    (let (
      (get_remain_list_inner (lambda (termlist_remain) (cadr termlist_remain)))
      (maxa (max_order a))
      (maxb (max_order b)))
      ; (display (get_remain_list_inner (div-terms a b)))(newline)
      (if (< maxa maxb)
          (get_remain_list_inner (div-terms b a))
          (get_remain_list_inner (div-terms a b)))))
  (define (max_order_coeff term_list)
    (define (iter m rest)
      (if (empty-termlist? rest)
          (error "max_order_coeff fail!")
          (let ((first_order (order (first-term rest)))
              (first_coeff (coeff (first-term rest))))
              (if (= first_order m)
                  first_coeff
                  (iter m (rest-terms rest))))))
    (let ((max_o (max_order term_list)))
         (iter max_o term_list)))
  
  (define (pseudoremainder-terms a b)
    (let (
      (get_remain_list_inner (lambda (termlist_remain) (cadr termlist_remain)))
      (maxa (max_order a))
      (maxb (max_order b))
      (scale_factor (lambda (x maxp maxm)
                            (let ((base (max_order_coeff x))
                                  (power (- (+ 1 maxp) maxm)))
                                 (make-term 0 (expt base power))))))
      ; (display (get_remain_list_inner (div-terms a b)))(newline)
      (if (< maxa maxb)
          (get_remain_list_inner (div-terms (mul-term-by-all-terms (scale_factor a maxb maxa) b ) a))
          (get_remain_list_inner (div-terms (mul-term-by-all-terms (scale_factor b maxa maxb) a ) b)))))



  (define (gcd-terms a b)
    (if (empty-termlist? b)
        (div_terms_divisor a (max_coeff_divisor a))
        (gcd-terms b (pseudoremainder-terms a b))))
  ; (display (div-terms '((4 1) (3 -1) (2 -2) (1 2)) '((3 1) (1 -1))))(newline)
  (define (greatest-common-divisor p1 p2)
    (let ((var1 (variable p1))
          (var2 (variable p2)))
          (if (same-variable? var1 var2)
              (make-poly var1 (gcd-terms (term-list p1) (term-list p2)))
              (error "Polys not in same var: 
                div-POLY"
                (list p1 p2))
          )))


  (define (max_coeff_divisor a)
    (apply gcd (map coeff a)))
  (define (div_terms_divisor terms divisor)
    (map (lambda (x) (make-term (order x) 
                                (div (coeff x) divisor)))
         terms))

  (define (reduce-terms a b)
    (define (scale_factor_terms a b)
      (let ((maxa (max_order a))
            (maxb (max_order b))
            (maxc (max_order_coeff b)))
            (let ((base maxc)
                  (power (- (+ 1 maxa) maxb)))
                  (let ((scale_factor (make-term 0 (expt base power))))
                    (list (mul-term-by-all-terms scale_factor a) 
                          (mul-term-by-all-terms scale_factor b))))))
    (let ((GCD (gcd-terms a b))
          (scale_term_list (scale_factor_terms a b)))
         (let ((min_terms_divisor (apply min 
                                         (map max_coeff_divisor 
                                              scale_term_list))))
              (map (lambda (terms) (div_terms_divisor terms min_terms_divisor)) 
                   scale_term_list))))


  (define (reduce-poly p1 p2)
    (if (same-variable? (variable p1) 
                        (variable p2))
        (map make-poly (list (variable p1) (variable p2))
                       (reduce-terms (term-list p1) (term-list p2)))
        (error "Polys not in same var: 
                reduce-POLY"
              (list p1 p2))
    ))


  ;; interface to rest of the system
  (define (tag p) (attach-tag 'polynomial p))
  (put '=zero? '(polynomial)
    (lambda (x) (empty-termlist? (term-list x))))
  (put 'negation '(polynomial)
    (lambda (x)
      (tag (negation-poly x))))
  (put 'make 'term
    make-term)
  (put 'sub '(polynomial polynomial)
    (lambda (p1 p2) 
      (tag (add-poly p1 (negation-poly p2))))
  )
  (put 'reduce '(polynomial polynomial)
       (lambda (p1 p2) 
         (map tag (reduce-poly p1 p2))))

  (put 'add '(polynomial polynomial)
       (lambda (p1 p2) 
         (tag (add-poly p1 p2))))
  (put 'greatest-common-divisor '(polynomial polynomial)
       (lambda (p1 p2) 
         (tag (greatest-common-divisor p1 p2))))
  (put 'mul '(polynomial polynomial)
       (lambda (p1 p2) 
         (tag (mul-poly p1 p2))))
  (put 'div '(polynomial polynomial)
       (lambda (p1 p2) 
         (tag (div-poly p1 p2))))
  (put 'get_remain_list '(polynomial)
       (lambda (p) 
         (get_remain_list p)))
  (put 'make 'polynomial
       (lambda (var terms) 
         (tag (make-poly var terms))))
  'install-polynomial-package-done)
(install-polynomial-package)


(define (make_term order coeff)
  ((get 'make 'term) order coeff))
(define (make-polynomial var terms)
  ((get 'make 'polynomial) var terms))

(define (get_remain_list n)
  (apply-generic 'get_remain_list n)
)
(define (reduce a b)
  (apply-generic 'reduce a b)
)

(define (greatest-common-divisor a b)
  (apply-generic 'greatest-common-divisor a b)
)

(define a (make-polynomial 'x '((2 2) (1 2) (0 2))))
(define b (make-polynomial 'x '((0 2))))
(display a)(newline)
(display b)(newline)
(display (reduce a b))(newline)
(display (reduce 4 2))(newline)
(display (make-rational a b))(newline)
(display (make-rational 4 2))(newline)

(define p1 
  (make-polynomial 'x '((1 1) (0 1))))
(define p2 
  (make-polynomial 'x '((3 1) (0 -1))))
(define p3 
  (make-polynomial 'x '((1 1))))
(define p4 
  (make-polynomial 'x '((2 1) (0 -1))))
(define rf1 (make-rational p1 p2))
(define rf2 (make-rational p3 p4))
(display (add rf1 rf2))
; Welcome to DrRacket, version 6.7 [3m].
; Language: SICP (PLaneT 1.18); memory limit: 128 MB.
; 'install_transform_done
; 'rational-package-done
; 'install-polynomial-package-done
; (polynomial x ((2 2) (1 2) (0 2)))
; (polynomial x ((0 2)))
; ((polynomial x ((2 1) (1 1) (0 1))) (polynomial x ((0 1))))
; (2 1)
; (rational (polynomial x ((2 1) (1 1) (0 1))) polynomial x ((0 1)))
; (rational 2 . 1)
; (rational (polynomial x ((4 1) (3 1) (2 1) (1 -2) (0 -1))) polynomial x ((5 1) (3 -1) (2 -1) (0 1)))
; > 